/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.fluid_generators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.ordana.immersive_weathering.data.fluid_generators.ModFluidGenerators;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;

public interface IFluidGenerator
extends Comparable<IFluidGenerator> {
    public static final Codec<IFluidGenerator> CODEC = Type.CODEC.dispatch("type", IFluidGenerator::getType, Type::codec);

    public Optional<class_2338> tryGenerating(List<class_2350> var1, class_2338 var2, class_1937 var3, Map<class_2350, class_2680> var4);

    public class_3611 getFluid();

    public FluidType getFluidType();

    public Type<?> getType();

    public int getPriority();

    default public class_3414 getSound() {
        return null;
    }

    @Override
    default public int compareTo(@NotNull IFluidGenerator o) {
        return Integer.compare(this.getPriority(), o.getPriority());
    }

    public record Type<T extends IFluidGenerator>(Codec<T> codec, String name) {
        private static final Codec<Type<?>> CODEC = Codec.STRING.flatXmap(name -> ModFluidGenerators.get(name).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown Fluid Generator type: " + name))), t -> DataResult.success((Object)t.name()));
    }

    public static enum FluidType implements class_3542
    {
        BOTH("both"),
        FLOWING("flowing"),
        STILL("still");

        public static final Codec<FluidType> CODEC;
        private final String name;

        private FluidType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String method_15434() {
            return this.name;
        }

        public boolean isStill() {
            return this != FLOWING;
        }

        public boolean isFlowing() {
            return this != STILL;
        }

        static {
            CODEC = class_3542.method_28140(FluidType::values);
        }
    }
}

